<?php

namespace App\Http\Controllers;

use App\AskmDimPelanggaran;
use App\AskmDimPenilaian;
use App\DimxDim;
use App\Keasramaan;
use Illuminate\Http\Request;
use App\SysxUser;
use Auth;
use Illuminate\Support\Facades\DB;
use function foo\func;

class DimController extends ResponseController
{
    //
    public function getDataPribadi()
    {
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = SysxUser::leftJoin("dimx_dim", function ($join) {
            $join->on('sysx_user.user_id', '=', 'dimx_dim.user_id');
        })->leftJoin("mref_r_agama", function ($join) {
            $join->on('dimx_dim.agama_id', '=', 'mref_r_agama.agama_id');
        })->leftJoin("mref_r_golongan_darah", function ($join) {
            $join->on('dimx_dim.golongan_darah_id', '=', 'mref_r_golongan_darah.golongan_darah_id');
        })->leftJoin("mref_r_jenis_kelamin", function ($join) {
            $join->on('dimx_dim.jenis_kelamin_id', '=', 'mref_r_jenis_kelamin.jenis_kelamin_id');
        })->where('dimx_dim.user_id', '=', $id)->first(['dimx_dim.nim as nim_mahasiswa',
            'dimx_dim.nama as nama_mahasiswa', 'dimx_dim.tgl_lahir as tanggal_lahir',
            'dimx_dim.tempat_lahir as tempat_lahir', 'dimx_dim.alamat', 'dimx_dim.kabupaten',
            'dimx_dim.kode_pos', 'dimx_dim.email','dimx_dim.hp', 'dimx_dim.hp2', 'dimx_dim.anak_ke',
            'dimx_dim.dari_jlh_anak', 'mref_r_jenis_kelamin.nama as jenis_kelamin',
            'mref_r_agama.nama as agama', 'mref_r_golongan_darah.nama as gol_darah'
        ]);
        if ($user) {
            return $this->successResponse(200, $user);
        } else {
            return $this->errorResponse(200, null, "Data Tidak ada");
        }
    }

    public function updateDataPribadi(Request $request){
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = DimxDim::where('dimx_dim.user_id','=', $id)->first();
        $user->nama = $request->nama == null ? $user->nama : $request->nama;
        $user->tgl_lahir = $request->tgl_lahir == null ? $user->tgl_lahir : $request->tgl_lahir;
        $user->tempat_lahir = $request->tempat_lahir == null ? $user->tempat_lahir : $request->tempat_lahir;
        $user->jenis_kelamin_id = $request->jenis_kelamin == null ? $user->jenis_kelamin_id : $request->jenis_kelamin;
        $user->agama_id = $request->agama == null ? $user->agama_id : $request->agama;
        $user->golongan_darah_id = $request->gol_dar == null ? $user->golongan_darah_id : $request->gol_dar;
        $user->alamat = $request->alamat == null ? $user->alamat : $request->alamat;
        $user->kabupaten = $request->kabupaten == null ? $user->kabupaten : $request->kabupate;
        $user->kode_pos = $request->kode_pos == null ? $user->kode_pos : $request->kode_pos;
        $user->email = $request->email == null ? $user->email : $request->email;
        $user->telepon = $request->telepon == null ? $user->telepon : $request->telepon;
        $user->hp = $request->hp == null ? $user->hp : $request->hp;
        $user->hp2 = $request->hp2 == null ? $user->hp2 : $request->hp2;
        $user->anak_ke = $request->anak_ke == null ? $user->anak_ke : $request->anak_ke;
        $user->dari_jlh_anak = $request->jumlah_anak == null ? $user->dari_jlh_anak : $request->jumlah_anak;
        $user->save();
        return $this->successResponse(201,$user,"Data Berhasil di update");
    }

    public function getDataAkademis()
    {
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = SysxUser::leftJoin("dimx_dim", function ($join) {
            $join->on('sysx_user.user_id', '=', 'dimx_dim.user_id');
        })->leftJoin("inst_prodi", function ($join) {
            $join->on('dimx_dim.ref_kbk_id', '=', 'inst_prodi.ref_kbk_id');
        })->leftJoin("adak_kelas", function ($join) {
            $join->on('inst_prodi.ref_kbk_id', '=', 'adak_kelas.prodi_id');
        })->leftJoin("hrdx_dosen", function ($join) {
            $join->on('adak_kelas.dosen_wali_id', '=', 'hrdx_dosen.dosen_id');
        })->leftJoin("hrdx_pegawai", function ($join) {
            $join->on('hrdx_dosen.pegawai_id', '=', 'hrdx_pegawai.pegawai_id');
        })->where('dimx_dim.user_id', '=', $id)->first([
            'dimx_dim.status_akhir',
            'dimx_dim.thn_masuk',
            'dimx_dim.user_name',
            'dimx_dim.email as email_akademik',
            'inst_prodi.nama_kopertis_ind as prodi',
            'adak_kelas.nama as kelas',
            'hrdx_pegawai.nama as wali_mahasiswa',
            'dimx_dim.jalur'
        ]);
        if ($user) {
            return $this->successResponse(200, $user);
        }
    }
    public function getDataOrangtua()
    {
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        
        $user = DB::selectOne('SELECT 
        dimx_dim.nama_ayah,dimx_dim.nama_ibu,dimx_dim.alamat_orangtua, pekerjaan_ayah.nama as pekerjaan_ayah,dimx_dim.keterangan_pekerjaan_ayah,
        penghasilan_ayah.nama as rentang_penghasilan_ayah, dimx_dim.penghasilan_ayah,dimx_dim.no_hp_ayah,
        pekerjaan_ibu.nama as pekerjaan_ibu,dimx_dim.keterangan_pekerjaan_ibu,penghasilan_ibu.nama as rentang_penghasilan_ibu,
        dimx_dim.penghasilan_ibu,dimx_dim.no_hp_ibu, dimx_dim.jumlah_tanggungan, dimx_dim.nama_wali,dimx_dim.alamat_wali, 
        pekerjaan_wali.nama as pekerjaan_wali, dimx_dim.keterangan_pekerjaan_wali,dimx_dim.telepon_wali,dimx_dim.no_hp_wali
        FROM sysx_user LEFT JOIN dimx_dim ON sysx_user.user_id = dimx_dim.user_id 
        LEFT JOIN mref_r_pekerjaan AS pekerjaan_ayah ON dimx_dim.pekerjaan_ayah_id = pekerjaan_ayah.pekerjaan_id 
        LEFT JOIN mref_r_pekerjaan AS pekerjaan_ibu ON dimx_dim.pekerjaan_ibu_id = pekerjaan_ibu.pekerjaan_id 
        LEFT JOIN mref_r_pekerjaan AS pekerjaan_wali ON dimx_dim.pekerjaan_wali_id = pekerjaan_wali.pekerjaan_id 
        LEFT JOIN mref_r_penghasilan AS penghasilan_ayah ON dimx_dim.penghasilan_ayah_id = penghasilan_ayah.penghasilan_id 
        LEFT JOIN mref_r_penghasilan AS penghasilan_ibu ON dimx_dim.penghasilan_ibu_id = penghasilan_ibu.penghasilan_id 
        LEFT JOIN mref_r_penghasilan AS penghasilan_wali ON dimx_dim.penghasilan_wali_id = penghasilan_wali.penghasilan_id 
        WHERE sysx_user.user_id = '.$id.';');
        if ($user) {
            return $this->successResponse(200, $user);
        }
    }


    // public function getDataOrangtua()
    // {
    //     $userLogin = \JWTAuth::parseToken()->authenticate();
    //     $id = $userLogin->user_id;
    //     $user = DimxDim::leftJoin('sysx_user',function($join){
    //         $join->on('dimx_dim.user_id','=','')
    //     })
    //     $user = DB::selectOne('SELECT dmx.nama_ayah, dmx.nama_ibu,dmx.nama_wali
    //     ,mrww.nama as pekerjaan_wali,keterangan_pekerjaan_wali,mrhW.nama as rentang_penghasilan_wali,
    //     ,dmx.alamat_orangtua, mrpA.nama as pekerjaan_ayah,dmx.penghasilan_wali,dmx.alamat_wali
    //     ,dmx.telepon_wali,dmx.no_hp_wali,dmx.kode_foto,dmx.keterangan_pekerjaan_ayah, mrhA.nama as rentang_penghasilan_ayah,dmx.penghasilan_ayah,
    //     dmx.no_hp_ayah,mriI.nama as pekerjaan_ibu, dmx.keterangan_pekerjaan_ibu,mrhI.nama as rentang_penghasilan_ibu,
    //     dmx.penghasilan_ibu, dmx.no_hp_ibu,dmx.telepon_wali, dmx.no_hp_wali, (dmx.penghasilan_ayah + dmx.penghasilan_ibu) as total_penghasilan,dmx.jumlah_tanggungan 
    //     from sysx_user sx
    //     left join dimx_dim dmx on sx.user_id = dmx.user_id
    //     left join mref_r_pekerjaan mrpA on dmx.pekerjaan_ayah_id = mrpA.pekerjaan_id
    //     left join mref_r_pekerjaan mriI on dmx.pekerjaan_ibu_id = mriI.pekerjaan_id
    //     left join mref_r_pekerjaan mrww on dmx.pekerjaan_wali_id = mrww.pekerjaan_id
    //     left join mref_r_penghasilan mrhA on dmx.penghasilan_ayah_id = mrhA.penghasilan_id
    //     left join mref_r_penghasilan mrhI on dmx.penghasilan_ibu_id = mrhI.penghasilan_id
    //     left join mref_r_penghasilan mrhW on dmx.penghasilan_wali_id = mrhW.penghasilan_id
    //     where sx.user_id = ' . $id . ' limit 1');
    //     if ($user) {
    //         return $this->successResponse(200, $user);
    //     }
    // }

    public function updateDataOrangtua(Request $request){
        // TODO() Update Data Ortu
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = DimxDim::where('dimx_dim.user_id', '=', $id)->first();
        $user->nama_ayah = $request->nama_ayah == null ? $user->nama_ayah : $request->nama_ayah;
        $user->nama_ibu = $request->nama_ibu == null ? $user->nama_ibu : $request->nama_ibu;
        $user->alamat_orangtua = $request->alamat_orangtua  == null ? $user->alamat_orangtua : $request->alamat_orangtua;
        $user->pekerjaan_ayah_id = $request->pekerjaan_ayah  == null ? $user->pekerjaan_ayah_id : $request->pekerjaan_ayah;
        $user->keterangan_pekerjaan_ayah = $request->keterangan_pekerjaan_ayah  == null ? $user->keterangan_pekerjaan_ayah : $request->keterangan_pekerjaan_ayah;
        $user->penghasilan_ayah_id = $request->rentang_penghasilan_ayah == null ? $user->penghasilan_ayah_id : $request->rentang_penghasilan_ayah;
        $user->penghasilan_ayah = $request->penghasilan_ayah  == null ? $user->penghasilan_ayah : $request->penghasilan_ayah; 
        $user->no_hp_ayah = $request->no_hp_ayah  == null ? $user->no_hp_ayah : $request->no_hp_ayah;
        $user->no_hp_ibu = $request->no_hp_ibu  == null ? $user->no_hp_ibu : $request->no_hp_ibu;
        $user->pekerjaan_ibu_id = $request->pekerjaan_ibu  == null ? $user->pekerjaan_ibu_id : $request->pekerjaan_ibu;
        $user->keterangan_pekerjaan_ibu = $request->keterangan_pekerjaan_ibu  == null ? $user->keterangan_pekerjaan_ibu : $request->keterangan_pekerjaan_ibu;
        $user->penghasilan_ibu_id = $request->rentang_penghasilan_ibu == null ? $user->penghasilan_ibu_id : $request->rentang_penghasilan_ibu;
        $user->penghasilan_ibu = $request->penghasilan_ibu == null ? $user->penghasilan_ibu : $request->penghasilan_ibu;
        $user->jumlah_tanggungan = $request->jumlah_tanggungan == null ? $user->jumlah_tanggungan : $request->jumlah_tanggungan;
        $user->nama_wali = $request->nama_wali == null ? $user->nama_wali : $request->nama_wali;
        $user->alamat_wali = $request->alamat_wali == null ? $user->alamat_wali : $request->alamat_wali;
        $user->pekerjaan_wali_id = $request->pekerjaan_wali == null ? $user->pekerjaan_wali_id : $request->pekerjaan_wali;
        $user->keterangan_pekerjaan_wali = $request->keterangan_pekerjaan_wali == null ? $user->keterangan_pekerjaan_wali : $request->keterangan_pekerjaan_wali;
        $user->penghasilan_wali_id = $request->rentang_penghasilan_wali == null ? $user->penghasilan_wali_id : $request->rentang_penghasilan_wali;
        $user->penghasilan_wali = $request->penghasilan_wali == null ? $user->penghasilan_wali : $request->penghasilan_wali;
        $user->telepon_wali = $request->telepon_wali == null ? $user->telepon_wali : $request->telepon_wali;
        $user->no_hp_wali = $request->no_hp_wali == null ? $user->no_hp_wali : $request->no_hp_wali;
        $user->save();
        return $this->successResponse(201,$user,"Data Berhasil di update");
    }

    public function updateDataSekolah(Request $request){
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = DimxDim::where('dimx_dim.user_id','=', $id)->first();
        $user->no_ijazah_sma = $request->no_ijazah_sma;
        $user->nama_sma = $request->nama_sma;
        $user->save();
        $data = array(
            'no_ijazah_sma' => $user->no_ijazah_sma,
            'nama_sma' => $user->nama_sma
        );

        return $this->successResponse(201,$data,"Data Berhasil di update");
    }

    public function getNilaiKuliah($idUser){

    }
    public function getDataAsalSekolah(){
        $userLogin = \JWTAuth::parseToken()->authenticate();
        $id = $userLogin->user_id;
        $user = DimxDim::leftJoin("sysx_user",function ($join){
            $join->on('dimx_dim.user_id','=','sysx_user.user_id');
        })->get([
            "no_ijazah_sma as noIjazah",
            "nama_sma as namaSekolah",
            "alamat_sma as alamatSekolah",
            "kabupaten_sma as kabupatenSma",
            "kodepos_sma as kodePos",
            "telepon_sma as telepon"
        ]);
        if ($user) {
            return $this->successResponse(200, $user);
        }
    }
}
?>
